//Ext.Loader.setConfig({
//    enabled : true,
//    paths: {
//    	'MyApp': 'app'
//    }
//});

Ext.apply(Ext.MessageBox.YES, {text : 'Ja', itemId: 'yes', ui: 'action'});
Ext.apply(Ext.MessageBox.NO, {text : 'Nein', itemId: 'no'});
Ext.apply(Ext.MessageBox.CANCEL, {text : 'Abbrechen', itemId: 'cancel'});
Ext.apply(Ext.MessageBox.OKCANCEL, [{text: 'OK', itemId: 'ok', ui : 'action'},{text: 'Abbrechen', itemId: 'cancel'}]);
Ext.apply(Ext.MessageBox.YESNO, [{text: 'Ja', itemId: 'yes', ui: 'action'},{text: 'Nein', itemId: 'no'}]);
Ext.apply(Ext.MessageBox.YESNOCANCEL, [{text: 'Ja', itemId: 'yes', ui: 'action'},{text: 'Nein', itemId: 'no'},{text: 'Abbrechen', itemId: 'cancel'}]);
    	
var scale = 1, startscale = 1, relX = 0, relY = 0, transX = 0, transY = 0; 
Ext.application({
	name : 'Photoalbum',
	controllers: ['App'],
	launch : function() {
		// This will appear in the Xcode console. Used for debugging.
		console.log('application launched');
		console.log('you are running phonegap with sencha touch on an '
				+ navigator.platform);

		Ext.Viewport.add([{
			xtype: 'panel',
			id: 'mainview',
			fullscreen: true,
			scrollable: 'both',
			items: [{
				docked : 'top',
				xtype : 'toolbar',
				layout: {
	                pack : 'center',
	                align: 'center'
	            },
	            defaults: {
	                iconMask: true,
	                iconAlign: 'top',
	            },
	            items: [{
	            	iconCls: 'album',
	            	id: 'photoselect'
	            }, {
	            	xtype: 'spacer'
	            }, {
	                iconCls: 'mail',
	                id: 'mailshare',
	            }, {
	            	xtype: 'spacer'
	            }, {
	            	iconCls: 'resize',
	            	id: 'zoomreset'
	            }, {
	            	xtype: 'spacer'
	            }, {
	            	iconCls: 'refresh',
	            	id: 'refresh',
	            }]
			}, {
				xtype: 'photoalbum-detail'
			}]
		}]);
		/**/
		Ext.get('mainview').on('pinchstart', function(e) {
			startscale = scale;
			//previous transform origin in screen coordinates
			var prevX = relX * 4500;
			var prevY = relY * 4500;
			// origin of the new touch event in screen coordinates
			var touchX = (e.touches[0].pageX + e.touches[1].pageX) / 2;
			var touchY = (e.touches[0].pageY + e.touches[1].pageY) / 2;
			// scrolling offset
			var scrollX = Ext.getCmp('mainview').getScrollable().getScroller().position.x;
			var scrollY = Ext.getCmp('mainview').getScrollable().getScroller().position.y;
			// distance between transform origins
			var deltaX = (touchX+scrollX) - prevX;
			var deltaY = (touchY+scrollY) - prevY;
			// undo previous scaling and translate it from previous origin
			var newX = parseFloat(deltaX / scale) + prevX;
			var newY = parseFloat(deltaY / scale) + prevY;
			// relative values
			relX = parseFloat(newX / 4500);
			relY = parseFloat(newY / 4500);
			// translate values
			transX += ((touchX+scrollX)-newX);
			transY += ((touchY+scrollY)-newY);
			// set transform origin
			Ext.getCmp('table').element.dom.firstChild.style.webkitTransformOrigin = 
				(relX*100) + "% "+ (relY*100) + "%";
		});
		Ext.get('mainview').on('pinch', function(e) {
			scale = startscale * e.scale;
			scale = (scale<0.25) ? scale=0.25 : ((scale>3) ? scale=3 : scale);
			Ext.getCmp('table').element.dom.firstChild.style.webkitTransform = 
				"translate("+parseInt(transX)+"px,"+parseInt(transY)+"px) scale("+scale+","+scale+")";
		});
	}
});